/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.common.items.QuiverItem;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundCycleQuiverPacket;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_918;
import org.jetbrains.annotations.NotNull;

public abstract class QuiverArrowSelectGui
extends class_329 {
    private static final class_2960 TEXTURE = Supplementaries.res("textures/gui/quiver_select.png");
    private static boolean usingItem;
    private static double lastCumulativeMouseDx;
    private static boolean usingKey;
    protected final class_918 itemRenderer;
    protected final class_310 minecraft;

    public static boolean isActive() {
        return usingItem || usingKey;
    }

    public static void setUsingItem(boolean on) {
        if (on != usingItem) {
            lastCumulativeMouseDx = 0.0;
        }
        usingItem = on;
    }

    public static boolean isUsingKey() {
        return usingKey;
    }

    public static void setUsingKeybind(boolean on) {
        if (on != usingItem) {
            lastCumulativeMouseDx = 0.0;
        }
        usingKey = on;
    }

    protected QuiverArrowSelectGui(class_310 minecraft, class_918 itemRenderer) {
        super(minecraft, itemRenderer);
        this.itemRenderer = itemRenderer;
        this.minecraft = minecraft;
    }

    public static void ohMouseMoved(double deltaX) {
        class_746 player;
        int oldI;
        int slotsMoved;
        double scale = (Double)class_310.method_1551().field_1690.method_42495().method_41753() * 0.02;
        if ((slotsMoved = (int)((lastCumulativeMouseDx += deltaX) * scale) - (oldI = (int)(lastCumulativeMouseDx * scale))) != 0 && (player = class_310.method_1551().field_1724) != null) {
            ServerBoundCycleQuiverPacket.Slot s = QuiverArrowSelectGui.getQuiverSlot((class_1657)player);
            NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundCycleQuiverPacket(slotsMoved, s));
        }
    }

    public static boolean onMouseScrolled(double scrollDelta) {
        class_746 player = class_310.method_1551().field_1724;
        NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundCycleQuiverPacket(scrollDelta > 0.0 ? -1 : 1, QuiverArrowSelectGui.getQuiverSlot((class_1657)player)));
        return true;
    }

    public static boolean onKeyPressed(int key, int action, int modifiers) {
        if (action == 1) {
            class_746 player = class_310.method_1551().field_1724;
            switch (key) {
                case 263: {
                    NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundCycleQuiverPacket(-1, QuiverArrowSelectGui.getQuiverSlot((class_1657)player)));
                    return true;
                }
                case 262: {
                    NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundCycleQuiverPacket(1, QuiverArrowSelectGui.getQuiverSlot((class_1657)player)));
                    return true;
                }
            }
            int number = key - 48;
            if (number >= 1 && number <= 9) {
                if (number <= CommonConfigs.Tools.QUIVER_SLOTS.get()) {
                    NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundCycleQuiverPacket(number - 1, QuiverArrowSelectGui.getQuiverSlot((class_1657)player), true));
                }
                return true;
            }
        }
        return false;
    }

    private void renderSlot(int pX, int pY, class_1657 pPlayer, class_1799 pStack, int seed) {
        if (!pStack.method_7960()) {
            this.itemRenderer.method_27951((class_1309)pPlayer, pStack, pX, pY, seed);
            RenderSystem.setShader(class_757::method_34540);
            this.itemRenderer.method_4025(this.minecraft.field_1772, pStack, pX, pY);
        }
    }

    public void renderQuiverContent(class_4587 poseStack, float partialTicks, int screenWidth, int screenHeight) {
        class_1657 player;
        class_1799 quiver;
        class_1297 class_12972 = this.minecraft.method_1560();
        if (class_12972 instanceof class_1657 && (quiver = QuiverArrowSelectGui.getCurrentlyUsedQuiver(player = (class_1657)class_12972)).method_7909() == ModRegistry.QUIVER_ITEM.get()) {
            poseStack.method_22903();
            QuiverItem.Data data = QuiverItem.getQuiverData(quiver);
            int selected = data.getSelectedSlot();
            List<class_1799> items = data.getContentView();
            int slots = items.size();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            int centerX = screenWidth / 2;
            int z = this.method_25305();
            this.method_25304(-90);
            int uWidth = slots * 20 + 2;
            int px = uWidth / 2;
            int py = screenHeight / 2 - 40;
            this.method_25302(poseStack, centerX - (px += ClientConfigs.Items.QUIVER_GUI_X.get().intValue()), py += ClientConfigs.Items.QUIVER_GUI_Y.get().intValue(), 0, 0, uWidth - 1, 22);
            this.method_25302(poseStack, centerX + px - 1, py, 0, 0, 1, 22);
            this.method_25302(poseStack, centerX - px - 1 + selected * 20, py - 1, 24, 22, 24, 24);
            this.method_25304(z);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            int i1 = 1;
            for (int i = 0; i < slots; ++i) {
                int kx = centerX - px + 3 + i * 20;
                this.renderSlot(kx, py + 3, player, items.get(i), i1++);
            }
            RenderSystem.disableBlend();
            class_1799 selectedArrow = items.get(selected);
            if (!selectedArrow.method_7960()) {
                this.drawHighlight(poseStack, screenWidth, py, selectedArrow);
            }
            poseStack.method_22909();
            QuiverArrowSelectGui.setUsingItem(true);
            return;
        }
        QuiverArrowSelectGui.setUsingItem(false);
    }

    @NotNull
    private static ServerBoundCycleQuiverPacket.Slot getQuiverSlot(class_1657 player) {
        return usingKey ? ServerBoundCycleQuiverPacket.Slot.INVENTORY : (player.method_6058() == class_1268.field_5808 ? ServerBoundCycleQuiverPacket.Slot.MAIN_HAND : ServerBoundCycleQuiverPacket.Slot.OFF_HAND);
    }

    private static class_1799 getCurrentlyUsedQuiver(class_1657 player) {
        if (usingKey) {
            return ((IQuiverEntity)player).getQuiver();
        }
        return player.method_6030();
    }

    protected abstract void drawHighlight(class_4587 var1, int var2, int var3, class_1799 var4);

    static {
        lastCumulativeMouseDx = 0.0;
        usingKey = false;
    }
}

